package java.game.cars;

import java.game.*;
import java.util.*;
import java.game.parts.*;
import java.game.parts.enginepart.airfueldeliverysystem.*;

public class Ninja_chassis extends Ninja_models
{
	public Ninja_chassis( int id )
	{
		super( id );
		carCategory = PACKAGE;

		vehicleName = vendorName = "Ninja";
		name = getName();
		
		rID_blueprint = cars.cat_01.Ninja:0x018Ar;
		defColorIndex = GameLogic.CARCOLOR_BLUE;
		
		game_version = 2.31;
		ban_mufflers = own_suspension = allow_missing_seats = 1;

		value = 3000;
 
		fully_stripped_drag = 0.55;
		min_drag = 0.355;
		drag_reduction_mul = 1.0;
		
		parts_shop_sml = new int[2];
		parts_shop_sml[0] = cars.cat_01.Ninja:0x01F5r; //Left taillight dark
		parts_shop_sml[1] = cars.cat_01.Ninja:0x01E6r; //Right taillight dark
		
		parts_shop_big = new int[2];
		parts_shop_big[0] = cars.cat_01.Ninja:0x010Fr; //Left exhaust
		parts_shop_big[1] = cars.cat_01.Ninja:0x010Er; //Right exhaust
	}

	public void addStockParts( Descriptor desc )
	{
		int actcolor = desc.color;
		float optical = desc.optical;
		float power = desc.power;
		
		super.addStockParts( actcolor, optical, power );

		float part_random;

		randomize( optical + power );

		// parts that have only one appearance //
		if ( optical >= 1.0 )
		{
			addPart( cars.cat_01.ninja:0x000000E3r, "L headlights", actcolor, optical, power );
			addPart( cars.cat_01.ninja:0x000000E4r, "R door", actcolor, optical, power );
			addPart( cars.cat_01.ninja:0x000000E5r, "RR window", actcolor, optical, power );
			addPart( cars.cat_01.ninja:0x000000E6r, "R taillights", actcolor, optical, power );
			addPart( cars.cat_01.ninja:0x000000E8r, "R headlights", actcolor, optical, power );
			addPart( cars.cat_01.ninja:0x000000E9r, "R seats", actcolor, optical, power );
			addPart( cars.cat_01.ninja:0x000000EAr, "FR seat", actcolor, optical, power );
			addPart( cars.cat_01.ninja:0x000000EBr, "RL window", actcolor, optical, power );
			addPart( cars.cat_01.ninja:0x000000ECr, "FR door", actcolor, optical, power );
			addPart( cars.cat_01.ninja:0x000000EDr, "FL door", actcolor, optical, power );
			addPart( cars.cat_01.ninja:0x000000F3r, "FL seat", actcolor, optical, power );
			addPart( cars.cat_01.ninja:0x000000F5r, "L taillights", actcolor, optical, power );
			addPart( cars.cat_01.ninja:0x000000F6r, "F windshield", actcolor, optical, power );
			addPart( cars.cat_01.ninja:0x0000010Fr, "L exhaust pipe", actcolor, optical, power );
		} else
		{
			if ( optical >= random() ) addPart( cars.cat_01.ninja:0x000000E3r, "L headlights", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.ninja:0x000000E4r, "R door", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.ninja:0x000000E5r, "RR window", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.ninja:0x000000E6r, "R taillights", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.ninja:0x000000E8r, "R headlights", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.ninja:0x000000E9r, "R seats", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.ninja:0x000000EAr, "FR seat", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.ninja:0x000000EBr, "RL window", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.ninja:0x000000ECr, "FR door", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.ninja:0x000000EDr, "FL door", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.ninja:0x000000F3r, "FL seat", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.ninja:0x000000F5r, "L taillights", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.ninja:0x000000F6r, "F windshield", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.ninja:0x0000010Fr, "L exhaust pipe", actcolor, optical, power );
		}

		// parts that have multiple appearance //
		if ( optical <= 1.0 )
		{
			if ( optical >= random() ) addPart( cars.cat_01.ninja:0x000000EEr, "R bumper", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.ninja:0x000000EFr, "F bumper", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.ninja:0x000000F0r, "R sideskirt", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.ninja:0x000000F4r, "L sideskirt", actcolor, optical, power );
		} else
		{
			part_random = random();
			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_01.ninja:0x000000FAr, "F bumper 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_01.ninja:0x000000FCr, "F bumper 2", actcolor, optical, power ); else
			addPart( cars.cat_01.ninja:0x000000EFr, "F bumper", actcolor, optical, power );

			part_random = random();
			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_01.ninja:0x00000104r, "L sideskirt 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_01.ninja:0x000000FBr, "L sideskirt 2", actcolor, optical, power ); else
			addPart( cars.cat_01.ninja:0x000000F4r, "L sideskirt", actcolor, optical, power );

			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_01.ninja:0x00000108r, "R sideskirt 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_01.ninja:0x00000109r, "R sideskirt 2", actcolor, optical, power ); else
			addPart( cars.cat_01.ninja:0x000000F0r, "R sideskirt", actcolor, optical, power );

			part_random = random();
			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_01.ninja:0x00000101r, "R bumper 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_01.ninja:0x000000FDr, "R bumper 2", actcolor, optical, power ); else
			addPart( cars.cat_01.ninja:0x000000EEr, "R bumper", actcolor, optical, power );

			part_random = random();
			if ( (optical-1)*part_random >= 0.5 ) addPart( cars.cat_01.ninja:0x00000103r, "Rf wing 3", actcolor, optical, power ); else
			addPart( cars.cat_01.ninja:0x00000100r, "Rf wing 2", actcolor, optical, power );
		}

		addPart( cars.cat_01.ninja:0x0000010Ar, "FR suspension" );
		addPart( cars.cat_01.ninja:0x0000010Br, "FL suspension" );
		addPart( cars.cat_01.ninja:0x0000010Cr, "RL suspension" );
		addPart( cars.cat_01.ninja:0x0000010Dr, "RR suspension" );

		if ( optical < 1.0 )
		{
			addPart( parts.wheels_combo:0x0000001Fr, "wheel" );
			addPart( parts.wheels_combo:0x0000001Fr, "wheel" );
			addPart( parts.wheels_combo:0x0000001Fr, "wheel" );
			addPart( parts.wheels_combo:0x0000001Fr, "wheel" );

		} else
		{
			if ( random() > 0.5 ) //Spider
			{
				if ( (power+optical)*0.5 >= 1.75 )
				{
					addPart( parts.wheels_combo:0x00000989r, "wheel" );
					addPart( parts.wheels_combo:0x00000989r, "wheel" );
					addPart( parts.wheels_combo:0x00000989r, "wheel" );
					addPart( parts.wheels_combo:0x00000989r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.5 )
				{
					addPart( parts.wheels_combo:0x00000988r, "wheel" );
					addPart( parts.wheels_combo:0x00000988r, "wheel" );
					addPart( parts.wheels_combo:0x00000988r, "wheel" );
					addPart( parts.wheels_combo:0x00000988r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.25 )
				{
					addPart( parts.wheels_combo:0x00000988r, "wheel" );
					addPart( parts.wheels_combo:0x00000988r, "wheel" );
					addPart( parts.wheels_combo:0x00000988r, "wheel" );
					addPart( parts.wheels_combo:0x00000988r, "wheel" );
				} else
				{
					addPart( parts.wheels_combo:0x000000A5r, "wheel" );
					addPart( parts.wheels_combo:0x000000A5r, "wheel" );
					addPart( parts.wheels_combo:0x000000A5r, "wheel" );
					addPart( parts.wheels_combo:0x000000A5r, "wheel" );
				}
			} else
			if ( random() > 0.5 ) //Sparkler
			{
				if ( (power+optical)*0.5 >= 1.75 )
				{
					addPart( parts.wheels_combo:0x00000985r, "wheel" );
					addPart( parts.wheels_combo:0x00000985r, "wheel" );
					addPart( parts.wheels_combo:0x00000985r, "wheel" );
					addPart( parts.wheels_combo:0x00000985r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.5 )
				{
					addPart( parts.wheels_combo:0x0000096Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000096Ar, "wheel" );
					addPart( parts.wheels_combo:0x00000985r, "wheel" );
					addPart( parts.wheels_combo:0x00000985r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.25 )
				{
					addPart( parts.wheels_combo:0x0000096Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000096Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000096Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000096Ar, "wheel" );
				} else
				{
					addPart( parts.wheels_combo:0x000000A6r, "wheel" );
					addPart( parts.wheels_combo:0x000000A6r, "wheel" );
					addPart( parts.wheels_combo:0x000000A6r, "wheel" );
					addPart( parts.wheels_combo:0x000000A6r, "wheel" );
				}
			} else //Flat
			{
				if ( (power+optical)*0.5 >= 1.75 )
				{
					addPart( parts.wheels_combo:0x00000962r, "wheel" );
					addPart( parts.wheels_combo:0x00000962r, "wheel" );
					addPart( parts.wheels_combo:0x00000962r, "wheel" );
					addPart( parts.wheels_combo:0x00000962r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.5 )
				{
					addPart( parts.wheels_combo:0x0000095Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000095Ar, "wheel" );
					addPart( parts.wheels_combo:0x00000962r, "wheel" );
					addPart( parts.wheels_combo:0x00000962r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.25 )
				{
					addPart( parts.wheels_combo:0x0000095Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000095Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000095Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000095Ar, "wheel" );
				} else
				{
					addPart( parts.wheels_combo:0x000000A2r, "wheel" );
					addPart( parts.wheels_combo:0x000000A2r, "wheel" );
					addPart( parts.wheels_combo:0x000000A2r, "wheel" );
					addPart( parts.wheels_combo:0x000000A2r, "wheel" );
				}
			}
		}

		if ( power >= 1.5 )
		{
			addPart( parts.running_gear:0x000001EFr, "shock" );
			addPart( parts.running_gear:0x000001EFr, "shock" );
			addPart( parts.running_gear:0x000001F0r, "shock" );
			addPart( parts.running_gear:0x000001F0r, "shock" );
		} else
		{
			addPart( parts.running_gear:0x000011FFr, "shock" );
			addPart( parts.running_gear:0x000011FFr, "shock" );
			addPart( parts.running_gear:0x000012FFr, "shock" );
			addPart( parts.running_gear:0x000012FFr, "shock" );
		}

		if ( power >= 1.5 )
		{
/*			if ( optical >= 1.5 )
			{
				addPart( parts.running_gear:0x000001BDr, "spring" );
				addPart( parts.running_gear:0x000001BDr, "spring" );
				addPart( parts.running_gear:0x000001BEr, "spring" );
				addPart( parts.running_gear:0x000001BEr, "spring" );
			} else*/
			{
				addPart( parts.running_gear:0x00000209r, "spring" );
				addPart( parts.running_gear:0x00000209r, "spring" );
				addPart( parts.running_gear:0x0000020Ar, "spring" );
				addPart( parts.running_gear:0x0000020Ar, "spring" );
			}
		} else
		{
			addPart( parts.running_gear:0x000013FFr, "spring" );
			addPart( parts.running_gear:0x000013FFr, "spring" );
			addPart( parts.running_gear:0x000014FFr, "spring" );
			addPart( parts.running_gear:0x000014FFr, "spring" );
		}

		if ( power >= 1.3 )
		{
			addPart( parts.running_gear:0x000021FFr, "FL brake" );
			addPart( parts.running_gear:0x000022FFr, "FR brake" );
			addPart( parts.running_gear:0x000023FFr, "RL brake" );
			addPart( parts.running_gear:0x000024FFr, "RR brake" );
		} else
		{
			addPart( parts.running_gear:0x000025FFr, "UL brake" );
			addPart( parts.running_gear:0x000026FFr, "UR brake" );
			addPart( parts.running_gear:0x000023FFr, "RL brake" );
			addPart( parts.running_gear:0x000024FFr, "RR brake" );
		}

		if ( power >= 1.6 )
		{
			addPart( parts.running_gear:0x00000154r, "F swaybar" );
			addPart( parts.running_gear:0x0000015Cr, "R swaybar" );
		} else
		{
			addPart( parts.running_gear:0x000041FFr, "F swaybar" );
			addPart( parts.running_gear:0x000042FFr, "R swaybar" );
		}

		if ( power >= 1.75 ) addPart( parts.engines.I4:0x0000000Br, "2.5L I4 engine", actcolor, optical, (power-1.75)/0.25*2 ); else
		if ( power >= 1.5 ) addPart( parts.engines.I4:0x0000000Ar, "2.2L I4 engine", actcolor, optical, (power-1.5)/0.25*2 ); else
		if ( power >= 1.25 ) addPart( parts.engines.I4:0x00000009r, "2.0L I4 engine", actcolor, optical, (power-1.25)/0.25*2 ); else
		if ( power >= 1 ) addPart( parts.engines.I4:0x00000008r, "1.8L I4 engine", actcolor, optical, (power-1)/0.25*2 );

		if ( optical <= 1.0 )
		{
			if ( optical >= random() ) addPart( cars.cat_01.ninja:0x000000E7r, "hood", actcolor, optical, power );
		} else
		{
			part_random = random();
			if ( optical-1 >= 0.5 ) addPart( cars.cat_01.ninja:0x00000102r, "hood 3", actcolor, optical, power ); else
			addPart( cars.cat_01.ninja:0x000000E7r, "hood", actcolor, optical, power );
		}

		if ( power >= 1.666 ) addPart( parts:0x000000E9r, "silver battery" ); else
		if ( power >= 1.333 ) addPart( parts:0x000000E8r, "blue battery" ); else
		addPart( parts:0x000053FFr, "black battery" );
		
		addPart( cars.cat_01.Ninja:0x0000FFB4r, "steering wheel" );
	}
	
	public void setDrive(int fwd, int rwd, float drive_front)
	{
		if((fwd && !rwd) || (rwd && !fwd)) super.setDrive(1,0,1.0); //2WD all becomes FWD
		else super.setDrive(fwd, rwd, drive_front); //Leave AWD alone 
	}
}
